#include "ReaderTool.h"

#include <QtGui>
#include <QApplication>
#include <QPixmap>
#include <QSplashScreen>
#include <QrfeSleeper>
#include <QrfeTrace>

#include <def.h>

uchar g_ReaderSuite_Major = MAJOR;
uchar g_ReaderSuite_Minor = MINOR;
uchar g_ReaderSuite_Version = VERSION;

#if (defined ALPHA)
#	define VERSION_EXTENSION		"a"
#elif (defined BETA)
#	define VERSION_EXTENSION		"b"
#elif (defined GAMMA)
#	define VERSION_EXTENSION		"c"
#elif (defined DELTA)
#	define VERSION_EXTENSION		"d"
#else
#	define VERSION_EXTENSION		""
#endif

QString g_ReaderSuite_VersionString;

int main(int argc, char *argv[])
{
	int res;

	while(1)
	{
        QApplication::setStyle("fusion");
        QApplication app(argc, argv);

    #ifdef Q_OS_MACX
        QDir dir(QApplication::applicationDirPath());
        dir.cdUp();
        dir.cd("PlugIns");
        QApplication::setLibraryPaths(QStringList(dir.absolutePath()));
    #endif

        QCoreApplication::setOrganizationName(COMPANY_NAME_FULL);
        QCoreApplication::setOrganizationDomain(COMPANY_DOMAIN);
        QCoreApplication::setApplicationName(APPLICATION_NAME);

#ifdef Q_OS_WIN32
		QrfeTrace::init(1, QrfeTrace::Trace2Stdout);
#endif

		g_ReaderSuite_VersionString = QString("%1.%2.%3")
					.arg((uint)g_ReaderSuite_Major)
					.arg((uint)g_ReaderSuite_Minor)
					.arg((uint)g_ReaderSuite_Version, 2, 10, QChar('0'));
		g_ReaderSuite_VersionString += VERSION_EXTENSION;

		QPixmap pixmap(":/logos/splashLogo");
		QSplashScreen splash(pixmap);
		splash.show();

		ReaderTool w;
		QObject::connect(&w, 		SIGNAL(showSplashMessage( const QString &, int, const QColor &)),
						 &splash, 	  SLOT(showMessage( const QString &, int, const QColor &)));

		if(!w.init(app.arguments()))
			return 0;

		w.show();

		splash.finish(&w);

		res = app.exec();

		if(res != RESTART_APPLICATION_CODE)
			break;

		QrfeSleeper::MSleepAlive(500);
	}

    return res;
}
